unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Ewert: TEdit;
    Werte: TLabel;
    LBwerte: TListBox;
    Bentfernen: TButton;
    Bwert: TButton;
    Bberechne: TButton;
    Label1: TLabel;
    Ende: TButton;
    Lsumme: TLabel;
    Lmittelw: TLabel;
    Label2: TLabel;
    procedure BwertClick(Sender: TObject);
    procedure BentfernenClick(Sender: TObject);
    procedure BberechneClick(Sender: TObject);
    procedure EndeClick(Sender: TObject);

private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

type  ra =  array  of real; // r(eal)a(rray) Feld variabler Lnge

 var
  Form1: TForm1;
  anz,ind : integer;         //Anzahl und Index (Listbox)
  tabelle: ra;

implementation

{$R *.dfm}
procedure TForm1.BwertClick(Sender: TObject);
begin
   anz := LBwerte.Items.Count;      // zhlen
   ind := LBwerte.ItemIndex;
   if ind < 0 then                  // keine Zeile markiert...
     LBwerte.Items[anz]:= Ewert.Text  // anhngen
    else
     LBwerte.Items[ind]:= Ewert.Text; // berschreiben
   anz := LBwerte.Items.Count;   // neu zhlen
end;

procedure TForm1.BentfernenClick(Sender: TObject);
begin
  ind := LBwerte.ItemIndex;     // gewhlten Eintrag ...
  Ewert.Text := LBwerte.Items[ind] ; // in Edit Wert bernehmen ...
  LBwerte.Items.Delete(ind);         // und lschen
  anz := LBwerte.Items.Count;   // noch verbliebene zhlen
end;

function summe(var liste: ra):real;
var i: integer;
    s: real;
begin
  s := 0;
  for i := 0 to High(liste) do s := s + liste[i];
  summe := s;                                    // Wertzuweisung
end;

function mittelwert(var  liste: ra):real;
begin
  mittelwert := summe(liste)/Length(liste) ;  // Funktionen benutzt!
end;

procedure gestalten(s,m : real);
begin
    if (s > 100) or (m > 25) then Form1.Lsumme.Color := clBlue;
    if S > 1000 then
    begin
     Form1.Lsumme.Color := clRed;
     Form1.Lsumme.Font.Name  := 'Courier New';
     Form1.Lsumme.Font.Height  := 18 ;
    end;
end;

procedure TForm1.BberechneClick(Sender: TObject);
var i  : integer;
    su ,mw: real;
begin
 SetLength(tabelle,anz); // Lnge festlegen
 for i := 0 to anz-1 do
   tabelle[i] := StrToFloat(LBwerte.Items[i]);
 // Summen- und Mittelwertfunktion benutzen:
 su := summe(tabelle);    // Funktionsaufruf (Rckgabe eines Wertes)
 mw := mittelwert(tabelle);
 Lsumme.Caption
    := 'Summe: '+FloatToStrF(su,ffFixed,10,2);
 Lmittelw.Caption
    := 'Mittelwert: '+FloatToStrF(mw,ffFixed,10,2);
 gestalten(su,mw);   // Prozeduraufruf
//oder auch unmittelbar aus Funktion ohne Ablage in Variablen
 gestalten(summe(tabelle),mittelwert(tabelle))
end;

procedure TForm1.EndeClick(Sender: TObject);
begin
close;
end;

end.
