unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Ewert: TEdit;
    Werte: TLabel;
    LBwerte: TListBox;
    Bentfernen: TButton;
    Bwert: TButton;
    Bberechne: TButton;
    LBtrend: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Ende: TButton;
    Lsumme: TLabel;
    Lmittelw: TLabel;
    LBx: TListBox;
    Image: TImage;
    Label3: TLabel;
    procedure BwertClick(Sender: TObject);
    procedure BentfernenClick(Sender: TObject);
    procedure BberechneClick(Sender: TObject);
    procedure EndeClick(Sender: TObject);

private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

type  ra =  array  of real;  // r(eal)a(rray) Feld variabler Lnge
      ia = array of integer; // i(nteger)a(rray)

var
  Form1: TForm1;
  anz,ind : integer;                   //Anzahl und Index (Listbox)
  xEinheiten: ia;
  tabelle, trendtabelle: ra;

implementation

{$R *.dfm}
procedure TForm1.BwertClick(Sender: TObject);
begin
   anz := LBwerte.Items.Count;      // zhlen
   ind := LBwerte.ItemIndex;
   if ind < 0 then                  // keine Zeile markiert...
     LBwerte.Items[anz]:= Ewert.Text  // anhngen
    else
     LBwerte.Items[ind]:= Ewert.Text; // berschreiben
   anz := LBwerte.Items.Count;   // neu zhlen
end;

procedure TForm1.BentfernenClick(Sender: TObject);
begin
  ind := LBwerte.ItemIndex;     // gewhlten Eintrag ...
  Ewert.Text := LBwerte.Items[ind] ; // in Edit Wert bernehmen ...
  LBwerte.Items.Delete(ind);         // und lschen
  anz := LBwerte.Items.Count;   // noch verbliebene zhlen
end;

function summe(var liste: ra):real;
var i: integer;
    s: real;
begin
    s := 0;
    for i := 0 to High(liste) do s := s + liste[i];
    summe := s;
end;

function mittelwert(var  liste: ra):real;
begin
  mittelwert := summe(liste)/Length(liste) ;
end;

procedure trend(var x: ia; y, trend : ra);  // y (Werte)
var az, hi, dx, i : integer;
    mw_y, anstieg : real;
    xx,xy :  ra;
begin
 az := Length(y);
 hi := High(y);      // hi = az-1  da Index ab 0
 SetLength(x, az);
 SetLength(xx, az);
 SetLength(xy, az);
 // x- Einheiten ... -2,-1,0,1,2...  oder ... -3,-1,+1,+3 ...
 // (-> Summe(x) = 0 -> vereinfachte Trendformel)
 if (az mod 2) = 0 then
   begin x[0] := -(az-1);   dx := 2  end     //
  else                                   // Anfangswert; Differenz
   begin x[0] := -(az-1) div 2; dx := 1  end;//
 for i := 1 tO hi do
    x[i] :=  x[i-1] + dx ;                // x-Einheiten fllen
 for i := 0 tO hi do
  begin
    xx[i] :=  x[i]* x[i];    // Quadrate x*x berechnen
    xy[i] :=  x[i]* y[i];    // Produkte x*y berechnen
  end;
// Formel Trendanstieg mit Summenfunktion
  anstieg :=  summe(xy)/summe(xx);
  mw_y := mittelwert(y);   // ... ist Schnittpunkt mit y-Achse
  for i := 0 tO hi do
    trend[i] := anstieg * x[i] + mw_y; //Werte der Trendgerade
end;

procedure TForm1.BberechneClick(Sender: TObject);
var i, x, y, deltax , deltay : integer;
begin
 Image.Canvas.Brush.Color := clWhite;
 Image.Canvas.Rectangle(0,0,520,360);
 SetLength(xEinheiten,anz);  // Lnge der arrays festlegen
 SetLength(tabelle,anz);
 SetLength(trendtabelle,anz);
 for i := 0 to anz-1 do
   tabelle[i] := StrToFloat(LBwerte.Items[i]);
 // Summen- und Mittelwertfunktion benutzen:
 Lsumme.Caption := 'Summe: '+FloatToStrF(summe(tabelle),ffFixed,10,2);
 Lmittelw.Caption := 'Mittelwert: '+FloatToStrF(mittelwert(tabelle),ffFixed,10,2);
 //Trendprozedur aufrufen:
 trend(xEinheiten, tabelle, trendtabelle);
 for i := 0 to anz-1 do
  begin
   LBx.Items[i] := IntToStr(xEinheiten[i]);
   LBtrend.Items[i] := FloatToStrF(trendtabelle[i],ffFixed,10,2) ;
  end;
  with Image.Canvas do   // Trendgerade zeichnen
  begin
     MoveTo(5,300);LineTo(495,300); // x-Achse
     MoveTo(255,5);LineTo(255,305); // y-Achse
     deltax := 500div(2*xEinheiten[anz-1]div(xEinheiten[1]-xEinheiten[0]));
     deltay := 300 div (round(trendtabelle[anz-1]-trendtabelle[0]));
     Brush.Color := clYellow;
     for i := 0 to anz-1 do        //Werte zeichnen
      begin
       x := 5 + i * deltax  ;
       y := 300-Round(tabelle[i])*deltay;
       Ellipse(x-4,y-4,x+4,y+4);
      end;
      x := 5;                                // Trendgerade zeichnen
      y := 300-Round(trendtabelle[0])*deltay;
      MoveTo(x,y);
      x := 505;
      y := 300-Round(trendtabelle[anz-1])*deltay;
      LineTo(x,y);
  end
end;

procedure TForm1.EndeClick(Sender: TObject);
begin
close;
end;

end.
