' --- Extensions - Erweiterungen und Vereinfachungen fr Anfnger --- 
'
' Einbindung aller verfgbaren Extensions durch ~exth im Programm nach der Zeile $H exth.ph
exth  = ~button : ~checkbox : ~edit : ~text : ~listbox : ~tooltip : ~show : ~hide : ~destroy : ~xcopy : ~even : ~odd : ~rad : ~deg : ~circle : ~polygon : ~triangle : ~square : ~cross ;
' Einzelne Extensions im Programm mit ~name nach der Zeile $H exth.ph einbinden z.B.:  ~button 
'--------------------------------------------------------------------------------------------------------------
' Controls im XProfan Hauptfenster erzeugen: x,y-Koordinate, Breite, Hhe, Beschriftungstext
button    = proc button:   parameters x%,y%,w%,h%,t$: return create("Button",  %hWnd,t$,x%,y%,w%,h%): endproc ;
checkbox  = proc checkbox: parameters x%,y%,w%,h%,t$: return create("CheckBox",%hWnd,t$,x%,y%,w%,h%): endproc ;
edit      = proc edit:     parameters x%,y%,w%,h%,t$: return create("Edit",    %hWnd,t$,x%,y%,w%,h%): endproc ;
text      = proc text:     parameters x%,y%,w%,h%,t$: return create("Text",    %hWnd,t$,x%,y%,w%,h%): endproc ;
listbox   = proc listbox:  parameters x%,y%,w%,h%   : return create("ListBox", %hWnd, 0,x%,y%,w%,h%): endproc ;                                                     
' Hilfstext fr Controls mit Control-Handle und Hilfstext.
tooltip   = proc tooltip:  parameters ch%,t$:                create("Tooltip", %hWnd,ch%,t$)        : endproc ;
'--------------------------------------------------------------------------------------------------------------
' Controls zeigen/ verstecken/ zerstren mit Control-Handle.
show      = proc show:     parameters hdl%: showwindow(hdl%,1) : endproc ;
hide      = proc hide:     parameters hdl%: showwindow(hdl%,0) : endproc ;
destroy   = proc destroy:  parameters hdl%: destroywindow(hdl%): endproc ;
'--------------------------------------------------------------------------------------------------------------
' Funktionsprozedur kopiert Listbox, Listen  und dynamische Felder, arrays : 
' a![], a%[] <--> liste sowie a![] <--> b%[] , 1.Parameter ist Quelle!
' Rckgabe der Anzahl der Werte 
xcopy     = proc xcopy :   if (ptype$(1) = "![]") and (ptype$(2) = "&"):parameters a![],h%: whileloop 0,sizeof(a![])-1: addstring(h%,str$(a![&loop])):endwhile :return sizeof(a![]):endif : if (ptype$(1) ="&") and (ptype$(2) = "![]"): parameters h%,a![] :whileloop 0,GetCount(h%)-1: a![&loop]=val(getstring$(h%,&loop)) :endwhile :return GetCount(h%):endif : if (ptype$(1) = "%[]") and (ptype$(2) = "&"): parameters a%[],h%: whileloop 0,sizeof(a%[])-1: addstring(h%,str$(a%[&loop])):endwhile :return sizeof(a%[]) :endif: if (ptype$(1) =  "&" ) and (ptype$(2) = "%[]"): parameters h%,a%[] :whileloop 0,GetCount(h%)-1: a%[&loop]=val(getstring$(h%,&loop)) :endwhile :return GetCount(h%) :endif: if (ptype$(1) = "![]") and (ptype$(2) = "%[]"): parameters a![],b%[]: whileloop 0,sizeof(a![])-1: b%[&loop]=round(a![&loop],0):endwhile :return sizeof(a![]) :endif: if (ptype$(1) = "%[]") and (ptype$(2) = "![]"): parameters a%[],b![]: whileloop 0,sizeof(a%[])-1: b![&loop]=a%[&loop]:endwhile :return sizeof(a%[]):endif: endproc ;
'--------------------------------------------------------------------------------------------------------------
' Eigenschaft  gerade/even, ungerade/odd  einer ganzen Zahl
even      = proc even:     parameters n%:   if (abs(n%) mod 2) = 0: return 1: else: return 0: endif : endproc ;     
odd       = proc odd:      parameters n%:   if (abs(n%) mod 2) = 1: return 1: else: return 0: endif : endproc ;
'--------------------------------------------------------------------------------------------------------------
' Winkel: Grad   --> in Bogen rad umrechnen
rad       =  proc rad:     parameters a! : return a!*Pi()/180: endproc ;
' Winkel: Bogen rad --> in Grad  umrechnen
deg       =  proc deg:     parameters a! : return a!*180/Pi(): endproc ;
'--------------------------------------------------------------------------------------------------------------
' Figuren um einen Mittelpunkt. Anwendung z.B. auch zum Markieren von Punkten auf einer Geraden, einer Polyline.
' Kreis um Mittelpunkt x,y mit Radius r . Anschlieend steht der Zeichenstift im Mittelpunkt.
circle    = proc circle:   parameters    x%,y%,r%: ellipse (x%-r%),(y%-r%),(x%+r%),(y%+r%): moveto x%,y%: endproc ;
' Regelmiges Polygon im Kreis mit n Ecken, Mittelpunkt x,y , Radius r [,optional Winkel a einer Ecke in Grad]. Anschlieend steht der Zeichenstift im Mittelpunkt.
polygon    = proc polygon: parameters n%,x%,y%,r%,a!:  var b!=rad(a!): moveto (x%+cos(b!)*r%),(y%-sin(b!)*r% ): whileloop 1,n%: b!=rad(a!+360/n%*&loop): lineto (x%+cos(b!)*r%),(y%-sin(b!)*r%): endwhile: moveto x%,y%: endproc ;
' gleichseitiges Dreieck im Kreis:  Mittelpunkt x,y , Radius r [,optional Winkel a einer Spitze in Grad].  Anschlieend steht der Zeichenstift im Mittelpunkt.
triangle  = proc triangle: parameters    x%,y%,r%,a!: polygon 3,x%,y%,r%,a! : endproc ;
' Quadrat im Kreis:  Mittelpunkt x,y , Radius r [,optional Winkel a einer Ecke in Grad]. Anschlieend steht der Zeichenstift im Mittelpunkt.
square    = proc square:   parameters    x%,y%,r%,a!: polygon 4,x%,y%,r%,a! : endproc ;
' Diagonales Kreuz im Kreis:  Mittelpunkt x,y , Radius r.  Anschlieend steht der Zeichenstift im Mittelpunkt.
cross     = proc cross:    parameters    x%,y%,r%: var sc%=0.707*r% :line (x%-sc%),(y%-sc%),(x%+sc%),(y%+sc%): line (x%-sc%),(y%+sc%),(x%+sc%),(y%-sc%): moveto x%,y%: endproc ;
'--------------------------------------------------------------------------------------------------------------
 